
function GetBoxExtrusion( factory, extrusionstartinput, rectframe )
{
	if ( rectframe == null )
		return false;

	var ui = moi.ui;

	var pointpicker = ui.createPointPicker();
	pointpicker.bindResultPt( factory.getInput(extrusionstartinput+1) );
	pointpicker.bindFunc( ui.commandUI.OnExtrusionPoint );
		
	pointpicker.restrictToLinePtDir( factory.extrusionBasePt, rectframe.zaxis, true );

	ui.commandUI.g_BoxFactory = factory;
	
	factory.setupBoxSnaps( pointpicker );

	ui.beginUIUpdate();
	ui.hideUI( 'LastRectPrompt' );
	ui.hideUI( 'WidthHeight' );
	ui.showUI( 'ExtrusionPrompt' );
	ui.showUI( 'ExtrusionInput' );
	ui.endUIUpdate();

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;

		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'extrusion' )
		{
			factory.setInput( extrusionstartinput, ui.commandUI.extrusion.value );
			factory.update();
			break;
		}
	}
	
	return true;
}
